<?php

namespace Models\Ais\Facility;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Position extends Model 
{

    protected $table = 'ais_facility_position';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function atcSessions()
    {
        return $this->hasMany('Models\Stats\Atc', 'position_id', 'position_id');
    }

    public function facility()
    {
        return $this->belongsTo('Models\Ais\Facility', 'facility_id', 'facility_id');
    }

}